<?php
/**
 * Spreadr Core Functions
 *
 * General core functions available on both the front-end and admin.
 *
 * @author 		Spreadr
 * @category 	Core
 * @package 	Spreadr/Functions
 * @version     0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function spreadr_maybe_define_constant( $name, $value ) {
	if ( ! defined( $name ) ) {
		define( $name, $value );
	}
}







add_action('admin_menu', 'spreadr_dashboard');
function spreadr_dashboard() {
	global $submenu;
	
	if (get_option( 'spreadr_token') != "") {
		$spreadr_token =  get_option( 'spreadr_token');
		$spreadrDashboardUrl = SPREADR_APP_URL."verifyuser/".$spreadr_token;
		$submenu['woocommerce'][] = array(
		'<div id="spreadrDashboard">Spreadr</div>', 'manage_options', $spreadrDashboardUrl);

	}
	
	
	
}

add_action( 'admin_footer', 'spreadr_dashboard_blank' );    
function spreadr_dashboard_blank()
{
	?>
	<script type="text/javascript">
		jQuery(document).ready(function($) {
			$('#spreadrDashboard').parent().attr('target','_blank');
			
		});
	</script>
	<?php
}


add_action( 'wp_ajax_spreadr_create_product', 'spreadr_create_product' );
add_action( 'wp_ajax_nopriv_spreadr_create_product', 'spreadr_create_product' );

function spreadr_create_product() {
	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden Spreadr', '403 Forbidden Spreadr', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }


	// Optional but strongly recommended: CSRF check
	if ( isset($_POST['_wpnonce']) && ! wp_verify_nonce( $_POST['_wpnonce'], 'spreadr_import' ) ) {
		wp_send_json_error( [ 'message' => 'Invalid request (nonce failed).' ], 400 );
	}

	// 1) Input: sanitize + validate
	if ( empty($_POST['product']) || ! is_array($_POST['product']) ) {
		wp_send_json_error( [ 'message' => 'Missing product payload.' ], 400 );
	}

	$product = sanitize_text_or_array_field_spreadr( $_POST['product'] );

	$title        = isset($product['title']) ? sanitize_text_field($product['title']) : '';
	$description  = isset($_POST['product']['body_html']) ? wp_kses_post($_POST['product']['body_html']) : '';
	$images       = isset($product['images']) && is_array($product['images']) ? $product['images'] : [];
	$feature_img  = !empty($images[0]['src']) ? esc_url_raw($images[0]['src']) : '';
	$metafields   = isset($product['metafields']) && is_array($product['metafields']) ? $product['metafields'] : [];
	$tags         = isset($product['tags']) ? $product['tags'] : ''; // kept for backward compat if needed elsewhere
	$is_published = !empty($product['published']) ? 'publish' : 'draft';

	$variants     = isset($product['variants']) && is_array($product['variants']) ? $product['variants'] : [];
	$first_var    = !empty($variants[0]) && is_array($variants[0]) ? $variants[0] : [];

	$price        = isset($first_var['price']) ? wc_format_decimal($first_var['price']) : '';
	$compare      = isset($first_var['compare_at_price']) ? wc_format_decimal($first_var['compare_at_price']) : '';

	// Extract known metafields we rely on (don’t assume order)
	$product_url  = '';
	$product_type = 0; // 0 = external (as per original), else simple
	$spreadr_tags = [];
	$category_name = '';

	foreach ( $metafields as $mf ) {
		if ( empty($mf['key']) ) { continue; }
		$key = sanitize_key( $mf['key'] );
		$val = is_scalar($mf['value']) ? wp_kses_post($mf['value']) : '';

		if ( 'spreadr_tags' === $key ) {
			$spreadr_tags = array_filter( array_map( 'sanitize_text_field', array_map( 'trim', explode(',', $val) ) ) );
		} elseif ( 'spreadr_category' === $key ) {
			$category_name = sanitize_text_field( $val );
		} elseif ( 'spreadr_product_button_type' === $key ) {
			$product_type = absint( $val );
		} elseif ( 'product_url' === $key ) {
			$product_url = esc_url_raw( $val );
		}
	}

	// Fallback: if no explicit metafield for product url but first metafield looked like it:
	if ( ! $product_url && ! empty($metafields[0]['value']) ) {
		$maybe_url = esc_url_raw( $metafields[0]['value'] );
		if ( filter_var( $maybe_url, FILTER_VALIDATE_URL ) ) {
			$product_url = $maybe_url;
		}
	}

	// 2) Create product post
	if ( '' === $title ) {
		wp_send_json_error( [ 'message' => 'Missing product title.' ], 400 );
	}

	$post_id = wp_insert_post( [
		'post_title'   => $title,
		'post_content' => $description,
		'post_status'  => $is_published,
		'post_type'    => 'product',
	], true );

	if ( is_wp_error( $post_id ) ) {
		wp_send_json_error( [ 'message' => 'Failed to create product.', 'error' => $post_id->get_error_message() ], 500 );
	}

	// 3) Images
	$gallery_ids = [];

	// Feature image
	if ( $feature_img ) {
		$thumbnail_id = spreadr_image_import( $feature_img, $post_id );
		if ( $thumbnail_id && ! is_wp_error($thumbnail_id) ) {
			update_post_meta( $post_id, '_thumbnail_id', (int) $thumbnail_id );
		}
	}

	// Gallery images (skip first)
	if ( count($images) > 1 ) {
		foreach ( array_slice($images, 1) as $img ) {
			if ( empty($img['src']) ) { continue; }
			$img_src  = esc_url_raw( $img['src'] );
			$image_id = spreadr_image_import( $img_src, $post_id );
			if ( $image_id && ! is_wp_error($image_id) ) {
				$gallery_ids[] = (int) $image_id;
			}
		}
		if ( ! empty($gallery_ids) ) {
			update_post_meta( $post_id, '_product_image_gallery', implode(',', $gallery_ids) );
		}
	}

	// 4) Metafields → post meta and taxonomy mapping
	foreach ( $metafields as $mf ) {
		if ( empty($mf['key']) ) { continue; }
		$key = sanitize_key( $mf['key'] );
		$val = is_scalar($mf['value']) ? wp_kses_post($mf['value']) : '';
		update_post_meta( $post_id, $key, $val );
	}

	// Tags
	if ( ! empty($spreadr_tags) ) {
		wp_set_object_terms( $post_id, $spreadr_tags, 'product_tag' );
	}

	// Category (create if needed)
	if ( $category_name ) {
		$existing = get_term_by( 'name', $category_name, 'product_cat' );
		if ( ! $existing ) {
			$created = wp_insert_term( $category_name, 'product_cat' );
			if ( is_wp_error( $created ) ) {
				error_log( 'Spreadr: error creating category: ' . $created->get_error_message() );
			} else {
				$term_id = (int) $created['term_id'];
				wp_set_object_terms( $post_id, $term_id, 'product_cat', true );
			}
		} else {
			wp_set_object_terms( $post_id, (int) $existing->term_id, 'product_cat', true );
		}
	}

	// 5) Product type + stock/visibility
	if ( (int) $product_type === 0 ) {
		// External product
		wp_set_object_terms( $post_id, 'external', 'product_type' );
		update_post_meta( $post_id, '_virtual', 'yes' );
	} else {
		wp_set_object_terms( $post_id, 'simple', 'product_type' );
	}

	// WooCommerce ≥3 uses product_visibility taxonomy.
	// Make sure it’s visible (i.e., not excluded); simplest is to clear the “exclude” terms.
	wp_remove_object_terms( $post_id, [ 'exclude-from-catalog', 'exclude-from-search' ], 'product_visibility' );

	update_post_meta( $post_id, '_stock_status', 'instock' );
	update_post_meta( $post_id, '_manage_stock', 'no' );
	update_post_meta( $post_id, '_backorders',  'no' );

	// 6) Pricing
	// If compare_at_price exists and is non-zero, treat it as regular price and set sale to price
	$regular = ( '' !== $compare && (float) $compare > 0 ) ? $compare : $price;
	$sale    = $price;

	if ( '' !== $regular ) { update_post_meta( $post_id, '_regular_price', $regular ); }
	if ( '' !== $sale )    { update_post_meta( $post_id, '_sale_price',    $sale ); }
	if ( '' !== $sale )    { update_post_meta( $post_id, '_price',         $sale ); }

	// For external products, set button URL when available
	if ( $product_url ) {
		update_post_meta( $post_id, '_product_url', esc_url_raw( $product_url ) );
	}

	// 7) Done
	wp_send_json( [
		'product_id' => (int) $post_id,
	] );
}




add_action( 'wp_ajax_spreadr_update_product', 'spreadr_update_product' );
add_action( 'wp_ajax_nopriv_spreadr_update_product', 'spreadr_update_product' );

function spreadr_update_product() {
	/* ---------- 0) AuthN & AuthZ ---------- */
	// Allow overriding/adding IPs via filter
	$allowed_ips = apply_filters('spreadr_allowed_ips', ['35.171.137.77']);
	$remote_ip   = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '';

	if ( ! $remote_ip || ! in_array($remote_ip, $allowed_ips, true) ) {
		wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
	}

	$api_key   = isset($_SERVER['HTTP_X_API_KEY']) ? $_SERVER['HTTP_X_API_KEY'] : '';
	$valid_key = (string) get_option( 'spreadr_token', '' );

	// Use timing-safe comparison when possible
	if ( empty($api_key) || empty($valid_key) || ! function_exists('hash_equals') || ! hash_equals($valid_key, $api_key) ) {
		wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
	}

	/* ---------- 1) Input validation & sanitization ---------- */
	if ( empty($_POST['product']) || ! is_array($_POST['product']) ) {
		wp_send_json_error( ['message' => 'Missing product payload.'], 400 );
	}

	$product = sanitize_text_or_array_field_spreadr( $_POST['product'] );

	$post_id      = isset($product['product_id']) ? absint($product['product_id']) : 0;
	$title        = isset($product['title']) ? sanitize_text_field($product['title']) : '';
	$description  = isset($_POST['product']['body_html']) ? wp_kses_post($_POST['product']['body_html']) : '';

	$images       = isset($product['images']) && is_array($product['images']) ? $product['images'] : [];
	$feature_img  = !empty($images[0]['src']) ? esc_url_raw($images[0]['src']) : '';

	$metafields   = isset($product['metafields']) && is_array($product['metafields']) ? $product['metafields'] : [];

	$variants     = isset($product['variants']) && is_array($product['variants']) ? $product['variants'] : [];
	$first_var    = !empty($variants[0]) && is_array($variants[0]) ? $variants[0] : [];

	// Prices
	$price        = isset($first_var['price']) ? wc_format_decimal($first_var['price']) : '';
	$compare      = isset($first_var['compare_at_price']) ? wc_format_decimal($first_var['compare_at_price']) : '';

	// Published status (optional)
	$published    = !empty($product['published']) ? 'publish' : 'draft';

	// Extract key metafields
	$product_url   = '';
	$product_type  = 0;           // 0=external, else simple (kept compatible with create function)
	$spreadr_tags  = [];
	$category_name = '';

	foreach ( $metafields as $mf ) {
		if ( empty($mf['key']) ) { continue; }
		$key = sanitize_key( $mf['key'] );
		$val = is_scalar($mf['value']) ? wp_kses_post($mf['value']) : '';

		if ( 'spreadr_tags' === $key ) {
			$spreadr_tags = array_filter( array_map( 'sanitize_text_field', array_map( 'trim', explode(',', $val) ) ) );
		} elseif ( 'spreadr_category' === $key ) {
			$category_name = sanitize_text_field( $val );
		} elseif ( 'spreadr_product_button_type' === $key ) {
			$product_type = absint( $val );
		} elseif ( 'product_url' === $key ) {
			$product_url = esc_url_raw( $val );
		}
	}

	// Fallback if first metafield holds URL
	if ( ! $product_url && ! empty($metafields[0]['value']) ) {
		$maybe_url = esc_url_raw( $metafields[0]['value'] );
		if ( filter_var( $maybe_url, FILTER_VALIDATE_URL ) ) {
			$product_url = $maybe_url;
		}
	}

	if ( ! $post_id || 'product' !== get_post_type( $post_id ) ) {
		wp_send_json_error( ['message' => 'Invalid product ID.'], 400 );
	}

	/* ---------- 2) Update the product post ---------- */
	$update_args = [
		'ID'           => $post_id,
		'post_title'   => $title ?: get_the_title($post_id),
		'post_content' => $description,
	];

	// If caller sent "published" flag, honor it
	if ( isset($product['published']) ) {
		$update_args['post_status'] = $published;
	}

	$result = wp_update_post( $update_args, true );
	if ( is_wp_error( $result ) ) {
		wp_send_json_error([
			'message' => 'Failed to update product.',
			'error'   => $result->get_error_message(),
		], 500 );
	}

	/* ---------- 3) Images (thumbnail + gallery) ---------- */
	$gallery_ids = [];

	// Feature image
	if ( $feature_img ) {
		$thumbnail_id = spreadr_image_import( $feature_img, $post_id );
		if ( $thumbnail_id && ! is_wp_error($thumbnail_id) ) {
			update_post_meta( $post_id, '_thumbnail_id', (int) $thumbnail_id );
		}
	}

	// Gallery: rebuild from provided list (excluding the first)
	if ( count($images) > 1 ) {
		foreach ( array_slice($images, 1) as $img ) {
			if ( empty($img['src']) ) { continue; }
			$img_src  = esc_url_raw( $img['src'] );
			$image_id = spreadr_image_import( $img_src, $post_id );
			if ( $image_id && ! is_wp_error($image_id) ) {
				$gallery_ids[] = (int) $image_id;
			}
		}
	}

	// Update gallery meta (replace with current set)
	update_post_meta( $post_id, '_product_image_gallery', implode(',', $gallery_ids) );

	/* ---------- 4) Metafields → post meta and taxonomies ---------- */
	foreach ( $metafields as $mf ) {
		if ( empty($mf['key']) ) { continue; }
		$key = sanitize_key( $mf['key'] );
		$val = is_scalar($mf['value']) ? wp_kses_post($mf['value']) : '';
		update_post_meta( $post_id, $key, $val );
	}

	// Tags
	if ( ! empty($spreadr_tags) ) {
		wp_set_object_terms( $post_id, $spreadr_tags, 'product_tag' );
	}

	// Category (create on the fly if needed)
	if ( $category_name ) {
		$existing = get_term_by( 'name', $category_name, 'product_cat' );
		if ( ! $existing ) {
			$created = wp_insert_term( $category_name, 'product_cat' );
			if ( is_wp_error( $created ) ) {
				error_log( 'Spreadr: error creating category during update: ' . $created->get_error_message() );
			} else {
				wp_set_object_terms( $post_id, (int) $created['term_id'], 'product_cat', true );
			}
		} else {
			wp_set_object_terms( $post_id, (int) $existing->term_id, 'product_cat', true );
		}
	}

	/* ---------- 5) Product type, visibility, stock ---------- */
	if ( (int) $product_type === 0 ) {
		// External product
		wp_set_object_terms( $post_id, 'external', 'product_type' );
		update_post_meta( $post_id, '_virtual', 'yes' );
	} else {
		wp_set_object_terms( $post_id, 'simple', 'product_type' );
	}

	// Visibility: remove "exclude" terms instead of legacy _visibility
	wp_remove_object_terms( $post_id, [ 'exclude-from-catalog', 'exclude-from-search' ], 'product_visibility' );

	update_post_meta( $post_id, '_stock_status', 'instock' );
	update_post_meta( $post_id, '_manage_stock', 'no' );
	update_post_meta( $post_id, '_backorders',  'no' );

	/* ---------- 6) Pricing ---------- */
	$regular = ( '' !== $compare && (float) $compare > 0 ) ? $compare : $price;
	$sale    = $price;

	if ( '' !== $regular ) { update_post_meta( $post_id, '_regular_price', $regular ); }
	if ( '' !== $sale )    { update_post_meta( $post_id, '_sale_price',    $sale ); }
	if ( '' !== $sale )    { update_post_meta( $post_id, '_price',         $sale ); }

	// Button URL for external
	if ( $product_url ) {
		update_post_meta( $post_id, '_product_url', esc_url_raw( $product_url ) );
	}

	/* ---------- 7) Done ---------- */
	wp_send_json( [
		'product_id' => (int) $post_id,
	] );
}





function spreadr_image_import($file,$parent_post_id) {
	

$filename = basename($file);



	if (file_get_contents($file)) {
		# test...

	$upload_file = wp_upload_bits($filename, null, file_get_contents($file));
	if (!$upload_file['error']) {
		$wp_filetype = wp_check_filetype($filename, null );
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_parent' => $parent_post_id,
			'post_title' => preg_replace('/\.[^.]+$/', '', $filename),
			'post_content' => '',
			'post_status' => 'inherit'
		);
		$attachment_id = wp_insert_attachment( $attachment, $upload_file['file'], $parent_post_id );


		if (!is_wp_error($attachment_id)) {
			require_once(ABSPATH . "wp-admin" . '/includes/image.php');
			$attachment_data = wp_generate_attachment_metadata( $attachment_id, $upload_file['file'] );
			wp_update_attachment_metadata( $attachment_id,  $attachment_data );
		}

		return $attachment_id;
	}
	} else {

	    $image = wp_remote_retrieve_body( wp_remote_get($file) );
	   	$upload_file = wp_upload_bits($filename, null, $image);

		if (!$upload_file['error']) {
			$wp_filetype = wp_check_filetype($filename, null );
			$attachment = array(
				'post_mime_type' => $wp_filetype['type'],
				'post_parent' => $parent_post_id,
				'post_title' => preg_replace('/\.[^.]+$/', '', $filename),
				'post_content' => '',
				'post_status' => 'inherit'
			);
			$attachment_id = wp_insert_attachment( $attachment, $upload_file['file'], $parent_post_id );


			if (!is_wp_error($attachment_id)) {
				require_once(ABSPATH . "wp-admin" . '/includes/image.php');
				$attachment_data = wp_generate_attachment_metadata( $attachment_id, $upload_file['file'] );
				wp_update_attachment_metadata( $attachment_id,  $attachment_data );
			}

			return $attachment_id;
		}

	}
}


add_action( 'wp_ajax_spreadr_isproduct_available', 'spreadr_isproduct_available' );
add_action( 'wp_ajax_nopriv_spreadr_isproduct_available', 'spreadr_isproduct_available' );

function spreadr_isproduct_available() {

	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$product_id = sanitize_text_or_array_field_spreadr($_POST['product_id']);

	$_product = wc_get_product( $product_id );
	if (!empty($_product)) {
		die(true);
	} else {
		die(false);
	}

}



add_action( 'wp_ajax_spreadr_installed', 'spreadr_installed' );
add_action( 'wp_ajax_nopriv_spreadr_installed', 'spreadr_installed' );

function spreadr_installed() {
	
	die(true);

}

//tmp
add_action( 'wp_ajax_spreadr_mark_product_outofstock', 'spreadr_mark_product_outofstock' );
add_action( 'wp_ajax_nopriv_spreadr_mark_product_outofstock', 'spreadr_mark_product_outofstock' );

function spreadr_mark_product_outofstock() {

	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	if ($_POST) {
		$product_id = sanitize_text_or_array_field_spreadr($_POST['product_id']);
		update_post_meta($product_id, '_stock_status', 'outofstock' );
		die(true);
	} else {
		die(false);
	}
	

}


add_action( 'wp_ajax_spreadr_mark_product_available', 'spreadr_mark_product_available' );
add_action( 'wp_ajax_nopriv_spreadr_mark_product_available', 'spreadr_mark_product_available' );

function spreadr_mark_product_available() {
	
	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	if ($_POST) {
		$product_id = sanitize_text_or_array_field_spreadr($_POST['product_id']);
		update_post_meta( $product_id, '_stock_status', 'instock' );
		die(true);
	} else {
		die(false);
	}

}

add_action( 'wp_ajax_spreadr_hide_product', 'spreadr_hide_product' );
add_action( 'wp_ajax_nopriv_spreadr_hide_product', 'spreadr_hide_product' );

function spreadr_hide_product() {
	
	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	if ($_POST) {
		$product_id = sanitize_text_or_array_field_spreadr($_POST['product_id']);	

		wp_update_post(array(
			'ID'    =>  $product_id,
			'post_status'   =>  'draft'
		));

		die(true);
	} else {
		die(false);
	}

}

add_action( 'wp_ajax_spreadr_delete_product', 'spreadr_delete_product' );
add_action( 'wp_ajax_nopriv_spreadr_delete_product', 'spreadr_delete_product' );

function spreadr_delete_product() {
	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	if ($_POST) {
		$product_id = sanitize_text_or_array_field_spreadr($_POST['product_id']);	

		wp_update_post(array(
			'ID'    =>  $product_id,
			'post_status'   =>  'trash'
		));

		die(true);
	} else {
		die(false);
	}

}

add_action( 'wp_ajax_spreadr_update_product_price', 'spreadr_update_product_price' );
add_action( 'wp_ajax_nopriv_spreadr_update_product_price', 'spreadr_update_product_price' );

function spreadr_update_product_price() {
	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	if ($_POST) {

	$product_id = sanitize_text_or_array_field_spreadr($_POST['product_id']);	

	$price = sanitize_text_or_array_field_spreadr($_POST['price']);
	$compare_price = sanitize_text_or_array_field_spreadr($_POST['compare_price']);
	if($compare_price != 0) {
      	update_post_meta( $product_id, '_regular_price', $compare_price );
    } else {
    	update_post_meta( $product_id, '_regular_price', $price );
    }
  
    update_post_meta($product_id, '_price', $price );

    if ($compare_price == 0) {
    		delete_post_meta($product_id, '_sale_price');

    } else  {
    		
    	 update_post_meta($product_id, '_sale_price', $price );
    }

	die(true);

	} else {
		die(false);
	}

}

add_action( 'wp_ajax_spreadr_review_settings', 'spreadr_review_settings' );
add_action( 'wp_ajax_nopriv_spreadr_review_settings', 'spreadr_review_settings' );

function spreadr_review_settings() {
	$allowed_ips = ['35.171.137.77']; 
    $remote_ip = $_SERVER['REMOTE_ADDR'];

    if (!in_array($remote_ip, $allowed_ips, true)) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }

	$api_key = $_SERVER['HTTP_X_API_KEY'];
    $valid_key = get_option( 'spreadr_token');
	
    if ($api_key !== $valid_key) {
        wp_die('Forbidden', '403 Forbidden', ['response' => 403]);
    }
	
	if ($_POST) {

	if( isset( $_POST['spreadr_review_token'] ) )
	update_option( 'spreadr_review_token', sanitize_text_or_array_field_spreadr($_POST['spreadr_review_token']) ,true );
	if( isset( $_POST['spreadr_review_userid'] ) )
	update_option( 'spreadr_review_userid', sanitize_text_or_array_field_spreadr($_POST['spreadr_review_userid']) ,true );
	if( isset( $_POST['spreadr_is_review_on'] ) )
	update_option( 'spreadr_is_review_on', sanitize_text_or_array_field_spreadr($_POST['spreadr_is_review_on']) ,true );
	if( isset( $_POST['spreadr_review_display'] ) )
	update_option( 'spreadr_review_display', sanitize_text_or_array_field_spreadr($_POST['spreadr_review_display']) ,true );
	
	

		die(true);
	} else {
		die(false);
	}

}




add_action( 'admin_notices', 'sp_subscriber_check_activation_notice' );
function sp_subscriber_check_activation_notice(){
     if( get_transient( 'spreadr_installing' ) ){
       echo '<script>window.open("'.SPREADR_APP_URL.'verifynewuser/'.get_option( 'spreadr_token').'", "_blank");</script>';
        delete_transient( 'spreadr_installing' );
    }
}


